<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

// dependencies

global $_ADMIN;

// && $_SESS["minibase"]["user"]

if ($_ADMIN) {
	switch ($_GET["sub"]) {
		case "core.sqladmin.file.upload":
			$file = true;
		case "core.sqladmin.image.upload":

			$mime = new CMime();
			$mime->Set("xml");

			//set_time_limit(0);

			//check to see if is a regular upload or a post one
			if ($_GET["tempName"]) {

				//fix the filename
				$_GET["tempName"] = str_replace(" " , "_" , $_GET['tempName'] );
	
				$to = '../upload/tmp/'. md5(uniqid(time())) . "_" . $_GET["tempName"];


				$input = fopen("php://input", "r");
				$temp = tmpfile();
				$realSize = stream_copy_to_stream($input, $temp);
				fclose($input);
								
				$target = fopen($to, "w");        
				fseek($temp, 0, SEEK_SET);
				stream_copy_to_stream($temp, $target);
				fclose($target);

			} else {
			
				if (is_array($_FILES['Filedata']) && !$_FILES['Filedata']["error"]) {
					//or is a regular file upload
					if (stristr($_FILES['Filedata']['name'] , " ")) {
						$_FILES['Filedata']['name'] = str_replace(" " , "_" , $_FILES['Filedata']['name'] );
					}
			
					$to = '../upload/tmp/'. md5(uniqid(time())) . "_" . $_FILES['Filedata']['name'];
					move_uploaded_file($_FILES['Filedata']['tmp_name'], $to);
				} else {

					if (!is_array($_FILES["Filedata"])) {

						//falling back to post 
						echo '<response>
							<status>xhr</status>
						</response>';
						die();


					}
					
				}
				
			}

			//back to regular processing

			if ($to) {
				if (!$file) {
					//check if the image its bigger then 2880x2880 ( the limit that flash cropper can handle )
					$image = @getImageSize($to);

					if ($image == false) {
						//error reading the image
						$response =	'<response>
									<status>failed</status>
									<message>Uploaded file its not a valid image!</message>
								</response>';
					} else {


						if (($image[0] > 2800 ) || ($image[1] > 2800)) {

							Image::newInstance()
								->Read($to)
								->ResizeFit(2500 , 2500)
								->Save($to , 90 )
								->Destroy();

						}						
					}
					
				}

				$response = 	
						'<response>
							<status>ok</status>
							<filePath>'.$to.'</filePath>
							<fileName>'.($_FILES["Filedata"]["name"] ? $_FILES["Filedata"]["name"] : $_GET["tempName"]) . '</fileName>
						</response>';
			} else {

				$response =	
						'<response>
							<status>failed</status>							
							<message>Server side upload error !</message>
						</response>';

			}

			echo $response;
			die();
		break;

		case "core.sqladmin.file.web":
			$isfile = true;
		case "core.sqladmin.image.web":

			$mime = new CMime();
			$mime->Set("xml");

			$file = basename($_POST['url']);

			//check if this is a link and if so remove everything after ?
			if (stristr($file , "?")) {
				$tmp = explode("?" , $file);
			}

			$file = str_replace("%20" , "_" , str_replace(" " , "_" , $tmp[0]));
			

			$to = '../upload/tmp/'. md5(uniqid(time())) . "_" . $file;

			//fix the filename if contains spaces
			if (stristr($to , " ")) {
				$to = str_replace(" " , "_" , $to );
			}


			CFile::Save(
				$to,
				CHTTP::NewInstance()
				->Get($_POST["url"] )
				->Raw()
			);


			if (!$isfile) {
				//check if the image its bigger then 2880x2880 ( the limit that flash cropper can handle )
				$image = getImageSize($to);

				if ($image == false) {
					//error reading the image
					$response =	'<response>
								<status>failed</status>
								<message>Specified link its not a valid image!</message>
							</response>';
				} else {
					if (($image[0] > 2800 ) || ($image[1] > 2800)) {

						if (($image[0] > 2800 ) || ($image[1] > 2800)) {

							Image::newInstance()
								->Read($to)
								->ResizeFit(2500 , 2500)
								->Save($to , 90 )
								->Destroy();

						}						
					}						
				}
			}

			echo '<response>
					<status>ok</status>
					<filePath>'. $to . '</filePath>
					<fileName>'. basename($from) . '</fileName>
				 </response>';

			die();

			echo '<response>
					<status>ok</status>
					<filePath>'. $to . '</filePath>
					<fileName>'. basename($from) . '</fileName>
				 </response>';

			die();

		break;

		case "core.sqladmin.file.delete":
			$file = true;
		case "core.sqladmin.image.delete":

			$mime = new CMime();
			$mime->Set("xml");

			$response =	'<response>
							<status>ok</status>
							<message></message>
						</response>';

			echo $response;

			die();
		break;
	}
}


?>
